
#include <avr/io.h>
#define F_CPU 16000000UL
#include <util/delay.h>
#include "LIN.h"

void USART1_Init (unsigned int baud)
{
	UCSR1A|=1<<U2X1;
	/* Set baud rate */
	UBRR1H = (unsigned char) (baud>>8);
	UBRR1L = (unsigned char) baud;
	/* Set frame format: 8data, no parity & 1 stop bits */
	UCSR1C = (0<<UMSEL1) | (0<<UPM1) | (0<<USBS1) | (1<<UCSZ10) | (1<<UCSZ11);
	/* Enable receiver and transmitter */
	UCSR1B = (1<<RXEN1) | (1<<TXEN1) ;//| (0<<UCSZ2);
	//stdout = &uart_str; // printf to UART
}

//---------------------------------------------------------------------------
int USART1_Transmit (unsigned char data)
{
	/* Put data into buffer, sends the data */
	UDR1 = data;
	/* Wait for empty transmit buffer */
	while ( ! ( UCSR1A & (1<<UDRE1)));
	return 0;
}
void LIN_init(uint16_t baud){
	//set TX pin as output
	DDRD=1<<PD3;
	//enable pull-up on the RX pin
	PORTD|=1<<PD2;
	//set the transmit enable pin to output
	DDRG|=1<<PG3;
	USART1_Init(baud);
}

void LIN_send(uint8_t b){
	USART1_Transmit(b);
}

void LIN_TXenable(void){
	PORTG|=1<<PG3;
}